# This contains random utilities used by perlmoo.

package Utils;
use strict;

{
	my $use_syslog=undef;

	# Output text. Priority is a syslog priority.
	sub Log {
		my $priority=shift || return;
		my $message=join('',@_);
		if (! $use_syslog) { # Log to stdout/err.
			if ($priority eq 'notice') {
				print STDERR localtime()." Perlmoo ($$): $message\n";
			}
			else {
				print localtime()." Perlmoo ($$): $message\n";
			}
		}
		else {
			syslog($priority,$message);
		}
	}

	# Call to enable logging to syslog.
	sub LogToSyslog {
		$use_syslog=1;
		
		require Sys::Syslog; import Sys::Syslog; # delayed use
		Sys::Syslog::setlogsock('unix');
		openlog("perlmoo","pid","daemon");
	}
}

# This makes the active user be a wizard. The wizard is a special one, that
# will not get dumped out, or even show up on the object list. Returns the 
# wizard.
sub SuWizard {
	ActiveUser::setactive();
	my $wiz=Wizard->new;
	$wiz->nodump(1);
	ActiveUser::setactive($wiz);
	ThingList::remove($wiz); # remove from object list.
	# Can't use $wiz->remove here, because this sub is called inside
	# Thing::remove, and it'd lead to a loop.
	return $wiz;
}

# Pass it any perl data structure and it will create a deep copy of it.
sub CopyConstructor {
	# For reason's I don't entirely understand, I can't use $_ here.
	my $a=$_[0];

	my $r=ref($a) || return $a; # scalar

	if ($r eq 'ARRAY') {
		my @ret=map CopyConstructor($_), @$a;
		return \@ret;
	}
	elsif ($r eq 'HASH') {
		my %hash=%$a;
		my %ret=();
		foreach my $key (keys %hash) {
			$ret{$key}=CopyConstructor($hash{$key});
		}
		return \%ret;
	}
	elsif ($r eq 'SCALAR' || $r eq 'REF') {
		# Dereference and try again.
		return CopyConstructor($$a);
	}
	elsif ($r eq 'GLOB' || $r eq 'CODE') {
		# Nothing to do with these.
		return $a;
	}
	else {
		# An object.
		# The only type of object we support copying is one
		# that is a hash. I don't know of a good way to detect 
		# how an object is implemented, so I will just use
		# eval. Hope this isn't too slow.
		# TODO: detect if an object is a hash, or a list,
		#       or a scalar, etc, and copy them all properly. No evals.
		my %hash=eval{%$a};
		return $a if $@;
		my %ret=();
		foreach my $key (keys %hash) {
			$ret{$key}=CopyConstructor($hash{$key});
		}
		return bless(\%ret,$r);
	}
}

1
