# A guest user. Guests are normal people, except when they log out, 
# they delete themselves, and they require no password to log in.
#
# TODO: other guest restrictions?

package Guest;
use strict;
use vars qw(@ISA);
use Person;
use Verb;
use VerbCall;
use UNIVERSAL qw(isa);
@ISA=qw{Person};

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $this  = Person::new($class,@_);
	bless ($this, $class);
	return $this;
}

# Allow anyone to log in as a guest, w/o specifying a password.
# However, if a guest is logged in, you can't steal their login the
# way a normal person can redirect their login by logging in from somewhere
# else.
sub login {
	my $this=shift;
	my $loginobject=shift;
	my @credentials=@_;

	my $wasactive=ActiveUser::getactive();
	ActiveUser::setactive($this);
	if (! $this->connected) {
		# Now set up this person to output using the correct
		# function.
		$this->output_callback($loginobject->output_callback);
		$this->close_callback($loginobject->close_callback);

		# And now instruct the server to replace the old loginobject
		# with this person.
		# FIXME: 'main::' -- ugly!
		main::ChangeClientObject($loginobject, $this);
		
		$this->connected(1);
		$this->lastlogin(time());
		$this->lastactive(time());
		$this->host($loginobject->host);
		
		$this->tell("** Logged in as ".$this->name." **");
		
		# Go home.
		if ($this->location) {
			$this->location->contents_remove($this);
		}
		$this->home->contents_add($this);
		
		$this->location->announce($this,$this->name." has connected.");
		return 1;
	}
	ActiveUser::setactive($wasactive);
	
	return undef
}

# When logging out, remove all objects from their possession, and send the
# objects to their homes. Then delete the guest.
sub logout {
	my $this=shift;
	
	my $thing;
	foreach $thing (@{$this->contents}) {
		$thing->home->contents_add($thing);
	}
	
	Person::logout($this);
	$this->remove;
}

1
