# Holds all the genders and pronouns associated with them.

package Gender;
use strict;
use vars qw(@ISA);
use Thing;
use Verb;
use UNIVERSAL qw(isa);
use Text;
use Error;
@ISA=qw{Thing};

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $this  = Thing::new($class,
		text => [],
		@_);
	bless ($this, $class);
	return $this;
}

# Pass it a gender, it will return 1 if the gender is defined in this object.
sub defined_gender {
	my $this=shift;
	my $gender=shift;
	
	foreach (@{$this->genders}) {
		return 1 if $_ eq $gender;
	}
	return undef;
}

# Pass it a gender and a pronoun specification, it'll return the appropriate
# pronoun for that gender.
sub getpronoun {
	my $this=shift;
	my $gender=shift;
	my $pronoun=shift;
	
	my $index=-1;
	my $c=0;
	foreach (@{$this->genders}) {
		if ($_ eq $gender) {
			$index=$c;
			last;
		}
		$c++;
	}
	
	return "" if $index == -1;
	
	return ${$this->pronouns}{$pronoun}[$index];
}

1
